#Proyecto 5. Lucho enciende las luces

El programa a realizar debe instruir a Lucho, nuestro robot de casa, para que encienda todas las luces 
que aparecen en el tablero, que están siempre en el mismo lugar. 
El tablero inicial es:

<center>
![El tablero inicial](data:image/png;base64,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)
</center>

Lo importante es que pienses de entrada una estrategia de solución, dividiendo en subtareas, y escribas 
procedimientos para expresarlas. 
Para eso, conviene primero nombrar las cosas que vemos: por ejemplo, la diagonal superior de luces, o 
la diagonal inferior. 
Entonces, una buena subtarea sería expresada por un procedimiento llamado `SubirEncendiendoLaDiagonalInferior`.

¿Te atrevés a dar dos programas diferentes, con distintas estrategias de solución para solucionar este problema? 
Fijate que también podés hacer un procedimiento para moverte de una diagonal a la otra… 
Y no te olvides de guardar el programa antes de modificarlo.

> **No existe “la” solución**
>
> Para solucionar un problema dado puede haber más de un programa que sirva. 
> O sea, no existe “la” solución.
> ¡Hay MUCHAS soluciones!

[Enunciado en PDF][PDF]

[PDF]: https://raw.githubusercontent.com/gobstones/curso-InPr-UNQ/master/Proyectos/2.Procedimientos/5.Lucho%20enciende%20las%20luces/assets/resources/description.pdf "Enunciado de 'Lucho enciende las luces' en PDF"
